<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="container py-5" style="background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%); min-height: 100vh;">
    <div class="row">
        <div class="col-12">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <div class="d-inline-flex align-items-center justify-content-center bg-white rounded-circle shadow-lg mb-4" style="width: 80px; height: 80px;">
                    <i class="bi bi-book text-primary" style="font-size: 2.5rem;"></i>
                </div>
                <h1 class="display-4 fw-bold text-white mb-3">Pelatihan</h1>
                <p class="lead text-white opacity-90">Riwayat pelatihan dan pengembangan diri</p>
            </div>

            <!-- Search and Filter Section -->
            <div class="card shadow-lg border-0 mb-5" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);">
                <div class="card-body">
                    <form method="GET" action="<?= base_url('training') ?>" class="row g-3">
                        <div class="col-md-3">
                            <label for="search" class="form-label text-primary fw-semibold">
                                <i class="bi bi-search me-2"></i>Cari Pelatihan
                            </label>
                            <input type="text" class="form-control border-primary" id="search" name="search" 
                                   value="<?= esc($search) ?>" placeholder="Cari nama pelatihan...">
                        </div>
                        <div class="col-md-2">
                            <label for="penyelenggara" class="form-label text-primary fw-semibold">
                                <i class="bi bi-building me-2"></i>Penyelenggara
                            </label>
                            <input type="text" class="form-control border-primary" id="penyelenggara" name="penyelenggara" 
                                   value="<?= esc($filter['penyelenggara']) ?>" placeholder="Filter penyelenggara...">
                        </div>
                        <div class="col-md-2">
                            <label for="tanggal_mulai" class="form-label text-primary fw-semibold">
                                <i class="bi bi-calendar me-2"></i>Tanggal Mulai
                            </label>
                            <input type="date" class="form-control border-primary" id="tanggal_mulai" name="tanggal_mulai" 
                                   value="<?= esc($filter['tanggal_mulai']) ?>">
                        </div>
                        <div class="col-md-2">
                            <label for="tanggal_selesai" class="form-label text-primary fw-semibold">
                                <i class="bi bi-calendar-check me-2"></i>Tanggal Selesai
                            </label>
                            <input type="date" class="form-control border-primary" id="tanggal_selesai" name="tanggal_selesai" 
                                   value="<?= esc($filter['tanggal_selesai']) ?>">
                        </div>
                        <div class="col-md-2">
                            <label for="sort" class="form-label text-primary fw-semibold">
                                <i class="bi bi-sort me-2"></i>Urutkan
                            </label>
                            <select class="form-select border-primary" id="sort" name="sort">
                                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                                <option value="nama_pelatihan" <?= $sort === 'nama_pelatihan' ? 'selected' : '' ?>>Nama Pelatihan</option>
                                <option value="tanggal_mulai" <?= $sort === 'tanggal_mulai' ? 'selected' : '' ?>>Tanggal Mulai</option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <label for="order" class="form-label text-primary fw-semibold">
                                <i class="bi bi-arrow-up-down me-2"></i>Order
                            </label>
                            <select class="form-select border-primary" id="order" name="order">
                                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
                            </select>
                        </div>
                        <div class="col-md-12 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-funnel me-1"></i>Filter
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Training List -->
            <?php if (empty($training)): ?>
                <div class="card shadow-lg border-0 text-center py-5" style="background: rgba(255, 255, 255, 0.95);">
                    <div class="card-body">
                        <i class="bi bi-info-circle text-primary mb-3" style="font-size: 3rem;"></i>
                        <h4 class="text-primary">Tidak ada pelatihan yang ditemukan</h4>
                        <p class="text-muted">Belum ada data pelatihan yang tersedia.</p>
                    </div>
                </div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach ($training as $t): ?>
                        <div class="col-12">
                            <div class="card shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);">
                                <div class="card-body p-4">
                                    <div class="row align-items-start">
                                        <div class="col-md-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="bg-primary rounded-circle p-3 me-3">
                                                    <i class="bi bi-book-fill text-white" style="font-size: 1.5rem;"></i>
                                                </div>
                                                <div>
                                                    <h4 class="text-primary fw-bold mb-1"><?= esc($t['nama_pelatihan']) ?></h4>
                                                    <?php if ($t['penyelenggara']): ?>
                                                        <p class="text-muted mb-0">
                                                            <i class="bi bi-building me-1"></i><?= esc($t['penyelenggara']) ?>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <?php if ($t['deskripsi']): ?>
                                                <div class="ms-5 ps-2">
                                                    <p class="text-dark mb-2"><?= nl2br(esc($t['deskripsi'])) ?></p>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($t['sertifikat']): ?>
                                                <div class="ms-5 ps-2">
                                                    <a href="<?= image_url('training', $t['sertifikat']) ?>" 
                                                       target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="bi bi-file-earmark-pdf me-1"></i>Lihat Sertifikat
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <?php if ($t['tanggal_mulai'] && $t['tanggal_selesai']): ?>
                                                <div class="badge bg-primary fs-6 px-3 py-2">
                                                    <i class="bi bi-calendar-range me-1"></i>
                                                    <?= date('d M Y', strtotime($t['tanggal_mulai'])) ?> - <?= date('d M Y', strtotime($t['tanggal_selesai'])) ?>
                                                </div>
                                            <?php elseif ($t['tanggal_mulai']): ?>
                                                <div class="badge bg-success fs-6 px-3 py-2">
                                                    <i class="bi bi-calendar me-1"></i>
                                                    Mulai: <?= date('d M Y', strtotime($t['tanggal_mulai'])) ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Pagination -->
                <?php if (isset($lastPage) && $lastPage > 1): ?>
                    <div class="row mt-5">
                        <div class="col-12">
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-center">
                                    <?php if ($currentPage > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('training?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <i class="bi bi-chevron-left"></i> Sebelumnya
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                                        <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                                            <a class="page-link" href="<?= base_url('training?page=' . $i . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <?= $i ?>
                                            </a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <?php if ($currentPage < $lastPage): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('training?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                Selanjutnya <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

